import codecs

# --- 1. DIZIONARI DI MAPPATURA (BASATI SULLA NOSTRA ANALISI) ---
MAPPA_RENDITA = {
    100: "ddd", 101: "dde", 200: "add"
    # Aggiungi altri valori man mano che li scopri
}
MAPPA_POSSESSO = { 100: "rrbegt", 50: "abead" }
MAPPA_MESE_INIZIO = { "Gennaio": "cn", "Febbraio": "dd", "Marzo": "de", "Aprile": "bq" }
MAPPA_MESE_FINE = { "Dicembre": "ddpdd", "Novembre": "dfodd" }
MAPPA_ALIQUOTA = { 11.4: "caddf", 10.6: "cuadd" }
MAPPA_STORICO_INAGIBILE = { "NO": "hop", "SI_STORICO": "dd", "SI_INAGIBILE": "cn" }

# --- 2. TEMPLATE DEL FILE .AMN (BASATO SU IUC_2025_20251021.amn) ---
TEMPLATE_HEADER = "zzaddeopsinmbugogoardreshorrhepppeserenmqqcyraessrsehekhpesehenmdqrrreccpevxhegcrfuurappqqarcvgcgtarcvgcgtarcvgcgtarcvgcgtarcvgcgtarcvgcgtadvhopcunmdpqqgcadfoqqcuadregcperrbekhcueerenmarvxhegcxvunreeearadvhopcuadcsgcperrbekhppcyracctheeregovsmubqiiii"
TEMPLATE_PAYLOAD = (
    "itaddpnmgtddcsxvdfserenmdfsecckhthddvhfagouufoggrfcykeggrfrekeaddfmuvhopxvddrappsivxrapparvxdfddsradfogodfserenmdfsecckhftddvhfagouufoggtheedrpppesereqaar"
    "{OUTPUT_TOTALE}"
    "srddvhddgoadvhmahoadde"
    "{MESE_INIZIO}"
    "hoaddecndfuufoggtheedrpppesereqaar"
    "{OUTPUT_SEMESTRE_1}"
    "srddvhddgoadvhmahoaddecnhoaddecndfuufoggtheedrpppesereqaarvxdfddsrddvhddgoadvhmahoaddecnhoaddecndfuufoggtheedrpppesereqaarvxdpddsrddvhddgoadvhmahoaddecnhoaddecndfuufoggtheedrccpeeeeskhthddvhfadfadvhopcunmdpqqg"
    "{ALIQUOTA}"
    "qqsi"
    "{MESE_FINE}"
    "xvddraqatheehersthrekeaddfmudfddcuaddeddbeuudacncuuudaadgcdddfgodfeedrqapprrraqaarvxdfddsrddvhddgoadvhmahoaddaddhoadsicndfuufoggtheedrccpeeeeskhftddvhfadfadvhopcunmdpqqgcaddfqqsiaddpddxvddraqatheehersthresidddfmudfddcuaddeddbeuudaopsiuudaadgcdddfgodfvxheccarcycsccgorekebegcresicndfmudfdddfuufoggfteecckhsiunretoarrrreesaraddfddsrdddfddxvddraespprekeccbecyrakharrrrecndfmudfdddfuufoggfteecckhrfeeeskhkerrcsbodfmuvhopxvddraespprekeqappcykenmcuddvhfadfdddfgodfvxheccarvxkekhppeeravxdfmudfdddfuufoggfteeheqaareerakhburrdrppdqddvhfadfdddfgodfvxheccthrekebeftcycvtoftrrdrmadfmudfdddfuufoggvhrrkeqaarvxkeesqqrekebeberrrappvhddvhfadfqavhddbenmcuddxvddbuggppvxhegcarvxkeesqqrekenmdqrrdpddsrddthvxcunmdacydfuufogghoeerenmrfrecstodqcycsnmppcycsnmdqreke"
    "{RENDITA_1}"
    "fmu"
    "{STORICO_INAGIBILE}"
    "xvddrabeppcykepparcydrkhsicykeccsicykekharadcckhdfddvhfagouufogghoeerenmrfrecstodqcycsnmppcycsnmdqresiggarvxdfddsradfogodfrrheccsieecckhrfrrrappsrsehekharvxdfddsradfogodfrrheccsieecckhrasehersppresiesarvxdfddsradfogodfrrheccsieecckhrfrrrappsrsehekharadppkhdfddvhfagouufogghoeerenmpprekeeerfrrraccarvxdfddsradfogodfrrheccsiseccgtgcresiesarvxdfddsradfogodfrrheccsiseccgtgcresiggarvxdfddsradfogodfrrheccsiseccgtcuresiesarvxdfddsradfogodfrrheccsiseccgtcuresiggarvxdfddsradfogodfcydrcccuvxbegtgcresiesarvxdfddsradfogodfcydrcccuvxbegtgcresiggarvxdfddsradfogodfcydrcccuvxbegtcuresiesarvxdfddsradfogodfcydrcccuvxbegtcuresiggarvxdfddsradfogodfcyraccpeeeesgtgcresiesarvxdfddsradfogodfcyraccpeeeesgtgcresiggarvxdfddsradfogodfcyraccpeeeesgtcuresiesarvxdfddsradfogodfcyraccpeeeesgtcuresiggarvxdfddsradfogodfcycsqadqcyrappvh"
    "{POSSESSO}"
    "gcresiesarvxdfddsraddpgodfcycsqadqcyrappvhrrbegtgcresiggarvxdfddsraddpgodfcycsqadqcyrappvhrrbegtcuresiesarvxdfddsraddpgodfcycsqadqcyrappvhrrbegtcuresiggarvxdfddsraddpgodfcyraccpeeedrppqqvxcckhdfddvhfagouufoggcueehersthsereqaftresiggarvxdfddsradfogodfcydrcccuvxkeccpeuncvccftrrdrccarvxdfddsradfogodfcydrcccuvxkeccpeuncvccftrrdrccaradppkhdfddvhfagouufoggsiundrkhcusehenmdqreke"
    "{RENDITA_2}"
    "fmuvhcnxvddbunmqqrrcsggrfvxkekharadppkhdfddvhfagcuufoggrfrrretodqcycsqaftrecstocusehebedqrecsnmpprrcckhdfresicndfmuvhopxvddrapphocydrkhsiundresarcycvggrfrrhekharcykecchorekeggaraddfddsradfogodfsehebegorrcsnmqqvxcckhgocyrapphorrbekhsieehebearvxdfddsradfogodfsehebegorrcsnmqqvxcckhsieehenmdqrrraqadqrecsnmpprrcckhdfresicndfmuvhopxvddrapphocydrkhsiundresarcykeccvhrrkersthrrbekhsieehebearvxppgtcuddvhfagouufoggrfrrretodqcycsqaftrecsnmppvxkekhpeeedrkharcykecchoreke"
    "{RENDITA_3}"
    "fmuvhopxvddrapphocydrkhsiundresarvxdfddsradfogodfsehebegorrcsnmqqvxcckhdfresicndfmuvhopxvddrapphocydrkhsiundresarvxppgtcuddvhfagouufoggrfrrretodqcycsqaftrekeggftcykeccarvxppgtgcddvhfagouufoggrfrrretodqcycsqaftrekeggftcykeccarvxppgtcuddvhfagouufogghoeerenmrfrecstodqcycsnmppcycsnmdqreke"
    "add" # Token fisso '100' Posizione 2
    "fmuvhopxvddrabeppcykepparcydrkhsicykeccsicykekharadcckhvhddvhfagouufogghoeerenmrfrecstodqcycsnmppcycsnmdqresiggar"
    "{OUTPUT_SEMESTRE_2}"
    "sradfogodfrrheccsieecckhrfrrrappsrsehekharvxcuddsradfogodfrrheccsieecckhrasehersppresiesarvxcuddsradfogodfrrheccsieecckhrfrrrappsrsehekharadppkhvhddvhfagouufogghoeerenmpprekeeerfrrraccarvxcuddsradfogodfrrheccsiseccgtgcresiesarvxcuddsradfogodfrrheccsiseccgtgcresiggarvxcuddsradfogodfrrheccsiseccgtcuresiesarvxcuddsradfogodfrrheccsiseccgtcuresiggarvxcuddsradfogodfcydrcccuvxbegtgcresiesarvxcuddsradfogodfcydrcccuvxbegtgcresiggarvxcuddsradfogodfcydrcccuvxbegtcuresiesarvxcuddsradfogodfcydrcccuvxbegtcuresiggarvxcuddsradfogodfcyraccpeeeesgtgcresiesarvxcuddsradfogodfcyraccpeeeesgtgcresiggarvxcuddsradfogodfcyraccpeeeesgtcuresiesarvxcuddsradfogodfcyraccpeeeesgtcuresiggarvxcuddsradfogodfcycsqadqcyrappvhrrbegtgcresiesarvxcuddsraddpgodfcycsqadqcyrappvhrrbegtgcresiggarvxcuddsraddpgodfcycsqadqcyrappvhrrbegtcuresiesarvxcuddsraddpgodfcycsqadqcyrappvhrrbegtcuresiggarvxcuddsraddpgodfcyraccpeeedrppqqvxcckhvhddvhfagouufoggcueehersthsereqaftresiggarvxcuddsradfogodfcydrcccuvxkeccpeuncvccftrrdrccarvxcuddsradfogodfcydrcccuvxkeccpeuncvccftrrdrccaradppkhvhddvhfagouufoggsiundrkhcusehenmdqrekeaddfmuvhcnxvddbunmqqrrcsggrfvxkekharadppkhvhddvhfagcuufoggrfrrretodqcycsqaftrecstocusehebedqrecsnmpprrcckhvhresicndfmuvhopxvddrapphocydrkhsiundresarcycvggrfrrhekharcykecchorekenmaraddfddsradfogodfsehebegorrcsnmqqvxcckhgocyrapphorrbekhsieehebearvxcuddsradfogodfsehebegorrcsnmqqvxcckhsieehenmdqrrraqadqrecsnmpprrcckhvhresicndfmuvhopxvddrapphocydrkhsiundresarcykeccvhrrkersthrrbekhsieehebearvxbegtcuddvhfagouufoggrfrrretodqcycsqaftrecsnmppvxkekhpeeedrkharcykecchorekeaddfmuvhopxvddrapphocydrkhsiundresarvxcuddsradfogodfsehebegorrcsnmqqvxcckhvhresicndfmuvhopxvddrapphocydrkhsiundresarvxbegtcuddvhfagouufoggrfrrretodqcycsqaftrekeggftcykeccarvxbegtgcddvhfagouufoggrfrrretodqcycsqaftrekeggftcykeccarvxbegtcuddvhfagouufogghoeerenmrfrecstodqcycsnmppcycsnmdqreke"
    "bqd"  # Token fisso '100' Posizione 3
    "fmuvhopxvddrabeppcykepparcydrkhsicykeccsicykekharadcckhthddvhfagouufogghoeerenmrfrecstodqcycsnmppcycsnmdqresiggar"
    "{OUTPUT_TOTALE_2}"
    "sradfogodfrrheccsieecckhrfrrrappsrsehekhareefoddsradfogodfrrheccsieecckhrasehersppresiesareefoddsradfogodfrrheccsieecckhrfrrrappsrsehekharadppkhthddvhfagouufogghoeerenmpprekeeerfrrraccareefoddsradfogodfrrheccsiseccgtgcresiesareefoddsradfogodfrrheccsiseccgtgcresiggareefoddsradfogodfrrheccsiseccgtcuresiesareefoddsradfogodfrrheccsiseccgtcuresiggareefoddsradfogodfcydrcccuvxbegtgcresiesareefoddsradfogodfcydrcccuvxbegtgcresiggareefoddsradfogodfcydrcccuvxbegtcuresiesareefoddsradfogodfcydrcccuvxbegtcuresiggareefoddsradfogodfcyraccpeeeesgtgcresiesareefoddsradfogodfcyraccpeeeesgtgcresiggareefoddsradfogodfcyraccpeeeesgtcuresiesareefoddsradfogodfcyraccpeeeesgtcuresiggareefoddsradfogodfcycsqadqcyrappvhrrbegtgcresiesareefoddsraddpgodfcycsqadqcyrappvhrrbegtgcresiggareefoddsraddpgodfcycsqadqcyrappvhrrbegtcuresiesareefoddsraddpgodfcycsqadqcyrappvhrrbegtcuresiggareefoddsraddpgodfcyraccpeeedrppqqvxcckhthddvhfagouufoggcueehersthsereqaftresiggareefoddsradfogodfcydrcccuvxkeccpeuncvccftrrdrccareefoddsradfogodfcydrcccuvxkeccpeuncvccftrrdrccaradppkhthddvhfagouufoggsiundrkhcusehenmdqreke"
    "bqd"  # Token fisso '100' Posizione 3
    "fmuvhcnxvddbunmqqrrcsggrfvxkekharadppkhthddvhfagcuufoggrfrrretodqcycsqaftrecstocusehebedqrecsnmpprrcckhthresicndfmuvhopxvddrapphocydrkhsiundresarcycvggrfrrhekharcykecchorekeqaaraddfddsradfogodfsehebegorrcsnmqqvxcckhgocyrapphorrbekhsieehebeareefoddsradfogodfsehebegorrcsnmqqvxcckhsieehenmdqrrraqadqrecsnmpprrcckhthresicndfmuvhopxvddrapphocydrkhsiundresarcykeccvhrrkersthrrbekhsieehebeareeesgtcuddvhfagouufoggrfrrretodqcycsqaftrecsnmppvxkekhpeeedrkharcykecchorekebqdfmuvhopxvddrapphocydrkhsiundresareefoddsradfogodfsehebegorrcsnmqqvxcckhthresicndfmuvhopxvddrapphocydrkhsiundresareeesgtcuddvhfagouufoggrfrrretodqcycsqaftrekeggftcykeccareeesgtgcddvhfagouufoggrfrrretodqcycsqaftrekeggftcykeccareeesgtcuddvhfagouufoggtheereqacuresicndfmuvhopxvddraqappuncvggaraddfddsradfogodfeedrccqqcyppgtsiddvhfagouufoggtheereqacuresibqdfmuvhopxvddraqappuncvggftvtrappdqrrraccarcykecchoresicndfmuvhopxvddraqappuncvggftvtrappdqrrraccarcykecchoresidddfmuvhopxvddrabeppcykepparcydrkhsicykeccsicykekharvxdpddsraddaddxvddrabeppcykepparcydrkhsicykeccsicykekharadcckhftddvhfagcaddpgodfrrheccsisecckhgorrcsnmsieerenmsirrbegtcurekecndfmuvhopxvddrabeppcykeccarsehersrfvtrappdqrekecndfmuvhcnxvddrabeppcykeccareerapppeeeccgtgcrekecndfmuvhopxvddrabeppcykeccarsehersrfvtrappdqresiggarvxdpddsradfogodfrrheccsieecckhraseherspprekecndfmuvhcncuuufogghoeerenmrfresiesaradcckhftddvhfakeuufogghoeerenmrfresiesaradppkhftddvhfagouufogghoeerenmrfresiggaradcckhftddvhfagouufogghoeerenmrfresiggaradppkhftddvhfakeuufogggoeereggvhresiesaradcckhftddvhfagcaddeopxvddbutoppcyranmaradccgtcurekecndfmuvhopxvddbutoppcyranmaradppgtgcrekecndfmuvhopxvddbutoppcyranmaradppgtcurekecndfmuvhcngoadfogodfcyraccpeeeesgtgcresiesarvxdpddsraddaopgouufoggcueehersthresiesaradppkhftddvhfagouufoggcueehersthresiggaradcckhftddvhfagouufoggcueehersthresiggaradppkhftddvhfagcaddeopxvddbunmqqrrcsggrfvxkekharadccgtgcrekecndfmuvhcnxvddbunmqqrrcsggrfvxkekharadccgtcurekecndfmuvhcnxvddbunmqqrrcsggrfvxkekharadppgtgcrekecndfmuvhcnxvddbunmqqrrcsggrfvxkekharadppgtcurekecndfmuvhcnxvddbuggpprrraqarfundresarvxdpddsraddaopgouufoggcueehersthsereqaftresiggarvxdpddsradfogodfcydrcccuvxkeccpeuncvccftrrdrccarvxdpddsraddaopgouufogggoeereggvheehersqqunheesxveeccgtcurekecndfmuvhopxvddbunmqqrrcsggrfvxkekharvxdpddsraddpgodfcycsqadqcyrappvhrrbegtcurekecndfmuvhcnxvddrapphocydrkhsiundresarcycvggrfrrhekharcykecchorekeesaraddpddsrmudamapenmsivxxvddrapphocydrkhsiundresarcycvggrfrrhekharcykecchorekeesaraddfddsradfogodfsehebegorrcsnmqqvxcckhgocyrapphorrbekhsieehebearvxdpddsrmudamapenmsivxxvddrapphocydrkhsiundresarcykeccvhrrkersthrrbekhsieehebearvxccgtgcddvhfagouufoggrfrrretodqcycsqaftrecsnmppvxkekhpeeedrkharcykecchorekeesaraddfddsrmudamapenmsivxxvddrapphocydrkhsiundresarcykeccvhrrkersthrrbekhsieehebearvxdpddsrmudamapenmsivxxvddrapphocydrkhsiundresarvxdpddsraddathgcuuvhmacuuufoggrfrrretodqcycsqaftrekeesaraddpddsraddathgcuuvhmacuuufoggrfrrretodqcycsqaftrekeesaraddfddsradfogodfsehebegorrcsnmqqvxcckhdfvxrenmpprekeesaraddpddsraddathgcuuvhmacuuufoggrfrrretodqcycsqaftrekeggftcykeccarvxccgtcuddvhfagouufoggpecycvggdqcyesgtgcresiesarvxdpddsraddpgodfrrbutocurrcstoaradccgtcurekecndfmuvhcnxvddrarsgocyrakhgoresiggaradcckhftddvhfagcuufoggpecycvggdqcyesgtcuresiggarvxdpddsraddpgodfeerenmpprrbuqapprekepphoundpddsradfogodfvxkekhthsehenmpprekenmdqrrreccpeeedpddsraddaboxvddranmdqeedrppvheecckhsiundresqqrrcuddsradfogodfserenmarvxheggrfundresqqddvhfagcuufogggocyrapphovxhenmftcykecndfmuvhopxvddrappsirekeesdfcycvggrfddvhfagouufoggrfcybekhvhrrkebedqeedresqqrrcuddsradfogodfcyrappthunrerfrfrrkerspprekepphounccgtbeadfoddsradfogodfcyrappthunrerfarsehebeberekeesxvuncvggftddvhfagouufoggvheehegcxvvxcckhrfrrheqqdfmudfggtorrcvqacueedptoftvxrappqqvxrerfrfrrkersrfddfoqqbosehebehorrkeggrfrrdrthbobqkeesqquudftotoddfoftqqcyraesperrramabobqdpgtgcadfothdfuufoggrfrrhethdfmuvhopxvddrarsberrcckhgocyrakhgocyrappppundrescusedpddsradfogodfrrbucchorecstocurrcstocuseheccqqvxreggrfaddfddsradfogodfrrbucchorekeeerfeekegcrfddvhfagouufoggtheereqacurekeeerfeekegcrfrrcuddsradfogodfeedrccqqcyraessrsehekhpeeecckhraddvhfagouufoggtheereqacuvxrerfrfrrkerspprekevxgcddvhfagouufoggtheereqacuvxrerfrfrrkerspprekevxcuddvhfagouufoggftrrdrppgcunhekhqqvxcckhrfrrremadfmuvhcngcuuvhbqxvddraesxvsereesberrcsqaftddvhfagcaddpvsqquufoggftrrdrppdfvxrenmppddvhfagcaddpvsqquufoggftrrdrppgcunhekhqqvxcckhdfvxrenmppddvhfagcaddpvsqquufoggvhvxreqappeekekhcusehecndfmuvhadxvddbunmbevxranmftuneskhvhvxrebqdfmuvhadxvddrappsirecsnmqqrrcsggrfvxkegtdfmuvhcnxvddrappsirecsnmqqrrcsggrfvxkekharaddfddsraddpgodfcyrappkevxhegcbeundresqqvxcckhftddvhfagcaddemaxvddbuggrfunraesxvunreqaftundresaradppkhftddvhfagouufoggkevxhegcdqcyraccarvxdpddsraddavxvsaddeopxvddbueeftrrdrkhcueeccgtcurekecndfmuvhopxvddraqappeecvccsrsehekhpeeedpddsradfogodfrrbucchorekepphorrcckhvhunredddfmuvhcnxvddrarsberrcckhrfrrhebearcycsbqdfmuvhopxvddrappsirekenmdqunrappthddvhfagouufoggrfcybekhvhrrcseerfeeesgtcuaddpddsradfogodfcyrappthrekeesrfcyramadfmuvhopxvddrapphocydrkhsiundresarvxraessieecckhftddvhfagcmudacnpenmdaddxvddrapphocydrkhsiundresareedrppvheecckhftddvhfagcmudacnpenmdaddxvddrapphocydrkhsiundresareedrppvheecckhftresicndfmuvhopxvddrapphocydrkhsiundresareedrppvheecckhftresidddfmuvhopxvddrapphocydrkhsiundresarvxraessieedpddsraddathgcuuvhmacuuufoggrfrrretodqcycsqaftrekeqarfvxkemadfmuvhcnrsaddpvsbeaddfgodfcydrescuundrccarvxkekhhounherspprekeggftcykemadfmuvhcnrsaddpvsbeaddfgodfcydrescuundrccarcycsqaftundrkharvxraessieedpddsradfogodfcydrescuundrccarvxkekhhounhersppddvhfagcmudacnpenmdaddxvddbutoftcybuqapprecsnmqqvxreqadqddvhfagouufoggrfrrretodqcycsqaftrekegcdqcyraqaftddvhfagcmudacnpenmdaddxvddbueeftrrdrkhcueecckhdfddvhfagouufoggcusereeeftrrcvccqqvxreqaftrekedddfmuvhopxvddbueeftrrdrkhcueeccgtcurekedddfmuvhopxvddbuggrfunraesxvunreqaftundresaradppkhdfddvhfagouufoggkevxhegcdqcyraccarvxcuddsradfogodfunraesxvrrcsggppresiggarvxcuddsradfogodfcyrappkevxhegcbeundresqqvxcckhvhddvhfagouufoggcusereeeftrrcvccqqvxreqaftresiggarvxcuddsradfogodfunraesxvrrcsggpprekebqdfmuvhopxvddbueeftrrdrkhcueeccgtcurekebqdfmuvhopxvddbuggrfunraesxvunreqaftundresareefoddsradfogodfcyrappkevxhegcbeundresqqvxccgtcurekebqdfmuvhopxvddbuggrfeecvccsrrekepphosedpddsradfogodfeedrccqqcyraessrrekepphosedpddsradfogodfeedrccqqcyppkhbeundrppxvddvhfagouufoggrfrrretodqcycsqaftrekersppuncvqaftddvhfagcmudacnpenmdaddxvddbunmpprrccgtgcddvhfarsnmdpvscsnmdfgodfcykecchoresidddfmuvhthbeuuvhcykeuufogggocyraccsieehersqqeedpddsradfogodfrrrakhhoeecckhvhrrkebeberrramadfmudfggnmdaqqqaesdathcndfuufoggvhsereggvhresithsiddvhfagouufoggrfcybekhbecyeskhdqsecuddsraddpgodfserenmarsehebebeddvhfagcuufoggkevxreggraseheunxvsedpddsrdddfddxvddbuggrfeeppkhrfrrhebegoddvhfadfdddfgodfcyrapprarekepphorrreopcuddvhfadf"
    "ddbuqqvharfoadgcaddeopvharfoadgcaddeopvharfoadii"
)
TEMPLATE_FOOTER = ( # Footer del file Base (invalido per payload modificati)
    "ccaddabogoarcnvxcunmdaungtadsithgcmucvgogoardetogtmudamapenmsimarsmudathrsmudathrsmudathrsmudappgtmudamapenmsieegtmudamapenmsieegtmudaeegtadcvgogoardetogtadcvgogoardecnrsaddpvsbeadbugogoardetogtmudamapenmsieegtaddetogtadcvgogoardetogtadcvgogcarcnvxcunmdaungtadregogoarcvftvseecvgcvsvtdreegteedresrscysiesarvxkenmgteedresrscysiqaarvxkenmgtaddaddcsardetogtadfovscunmcvgogcardecnkeuusiopkeuusiddgoadvhccgtaddavxdqaddadddqadvhopcunmregogoardecnkeadopiiii"
)

# --- 3. FUNZIONE DI CODIFICA ---
def crea_payload(dati_input):
    payload = TEMPLATE_PAYLOAD
    rendita_val = dati_input.get('rendita', 100)
    possesso_val = dati_input.get('possesso', 100)
    mese_inizio_val = dati_input.get('mese_inizio', "Gennaio")
    mese_fine_val = dati_input.get('mese_fine', "Dicembre")
    aliquota_val = dati_input.get('aliquota', 11.4)
    storico_val = dati_input.get('storico_inagibile', "NO")

    try:
        payload = payload.replace("{RENDITA_1}", MAPPA_RENDITA[rendita_val])
        payload = payload.replace("{RENDITA_2}", MAPPA_RENDITA[rendita_val])
        payload = payload.replace("{RENDITA_3}", MAPPA_RENDITA[rendita_val])
        payload = payload.replace("{POSSESSO}", MAPPA_POSSESSO[possesso_val])
        payload = payload.replace("{MESE_INIZIO}", MAPPA_MESE_INIZIO[mese_inizio_val])
        payload = payload.replace("{MESE_FINE}", MAPPA_MESE_FINE[mese_fine_val])
        payload = payload.replace("{ALIQUOTA}", MAPPA_ALIQUOTA[aliquota_val])
        payload = payload.replace("{STORICO_INAGIBILE}", MAPPA_STORICO_INAGIBILE[storico_val])
    except KeyError as e:
        print(f"--- ERRORE: VALORE NON MAPPATO ---")
        print(f"Il valore '{e.args[0]}' non è presente nei dizionari di mappatura.")
        return None

    # Valori di Output (lasciati come nel file base - ERRATI)
    payload = payload.replace("{OUTPUT_TOTALE}", "eefodd")
    payload = payload.replace("{OUTPUT_SEMESTRE_1}", "vxcudd")
    payload = payload.replace("{OUTPUT_SEMESTRE_2}", "vxcudd")
    payload = payload.replace("{OUTPUT_TOTALE_2}", "eefodd")

    return payload

# --- 4. ESECUZIONE ---
print("--- GENERATORE DI FILE .AMN (SOLO PAYLOAD 'Altre abitazioni') ---")
nuovi_dati = {
    "rendita": 101,
    "possesso": 50,
    "mese_inizio": "Aprile",
    "mese_fine": "Novembre",
    "aliquota": 10.6,
    "storico_inagibile": "SI_INAGIBILE"
}
print(f"Dati di input: {nuovi_dati}\n")

nuovo_payload = crea_payload(nuovi_dati)

if nuovo_payload:
    contenuto_file_generato = TEMPLATE_HEADER + nuovo_payload + TEMPLATE_FOOTER
    nome_file_output = "File_Generato_Python_Codifica.amn"
    try:
        with codecs.open(nome_file_output, 'w', encoding='latin-1') as f:
            f.write(contenuto_file_generato)
        print(f"--- SUCCESSO ---")
        print(f"File '{nome_file_output}' generato.")
        print("ATTENZIONE: Il file NON è valido per il caricamento sul sito.")
    except Exception as e:
        print(f"Errore durante il salvataggio: {e}")